/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminCommon;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import filenet.vw.toolkit.utils.uicontrols.security.IVWRecipientSelectionPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWRecipientComboPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWRecipientFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class VWAdminAssignReassignDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener {
    private VWAdminResultPane m_resultsPane;
    private VWSession m_vwSession = null;
    private Frame m_parentFrame = null;
    private Vector m_wobsList = new Vector();
    private JButton m_okButton = null;
    private JButton m_applyButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private boolean m_bCanceled = true;
    private boolean m_bLocked = false;
    private IVWRecipientSelectionPanel m_toRecipientPanel = null;
    private VWTable m_table = null;
    private MyTableModel m_tableModel = null;
    private JScrollPane m_scrollPane = null;
    private JTextArea m_commentsUI = null;
    private JTextArea m_newCommentsUI = null;
    private JCheckBox m_delegateUI = null;
    private JRadioButton m_appendRadio = null;
    private JRadioButton m_replaceRadio = null;

    public VWAdminAssignReassignDialog(Vector selectedWork, VWAdminResultPane resultsPane) {
        super(resultsPane.getParentFrame());
        this.m_parentFrame = resultsPane.getParentFrame();
        this.m_vwSession = resultsPane.getSession();
        this.m_wobsList = selectedWork;
        this.m_resultsPane = resultsPane;
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        Dimension dim = VWStringUtils.stringToDimension("665,495");
        if (dim == null) {
            dim = new Dimension(600, 450);
        }
        this.setSize(dim.width, dim.height);
        this.setTitle(VWResource.s_assignReassignDlgTitle);
        this.setVisible(false);
        this.setLocationRelativeTo(this.m_parentFrame);
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        this.pack();
        this.disableControls();
        this.addWindowListener(new VWWindowAdapter(this));
    }

    public void windowClosing(WindowEvent event) {
        super.windowClosing(event);
        this.m_bCanceled = true;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_toRecipientPanel)) {
            this.setButtonState();
        } else if (event.getSource().equals(this.m_okButton)) {
            this.reassignWork();
            this.m_bCanceled = false;
            this.setVisible(false);
        } else if (event.getSource().equals(this.m_applyButton)) {
            this.reassignWork();
            this.refreshPanel();
        } else if (event.getSource().equals(this.m_cancelButton)) {
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (event.getSource().equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Admin + "bpfah030.htm");
        }
    }

    protected boolean getStatus() {
        return this.m_bCanceled;
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        try {
            JPanel fromToListPanel = new JPanel();
            this.setupFromToListPanel(fromToListPanel);
            JPanel commentsPanel = new JPanel();
            this.setupCommentsPanel(commentsPanel);
            mainPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 23;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            mainPanel.add((Component)fromToListPanel, c);
            c.gridx = 0;
            ++c.gridy;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 0.4;
            mainPanel.add((Component)commentsPanel, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(2, 2, 5, 2);
            this.m_delegateUI = new JCheckBox(VWResource.s_delegate);
            VWAccessibilityHelper.setAccessibility(this.m_delegateUI, this, VWResource.s_delegate, VWResource.s_delegate);
            this.m_delegateUI.addKeyListener(VWKeyAdapter.s_keyAdapter);
            mainPanel.add((Component)this.m_delegateUI, c);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel setupFromToListPanel(JPanel panel) {
        try {
            this.m_tableModel = new MyTableModel(this.m_wobsList);
            this.m_table = new VWTable(this.m_tableModel);
            this.m_table.setPreferredScrollableViewportSize(new Dimension(500, 100));
            this.m_table.setShowGrid(false);
            VWAccessibilityHelper.setAccessibility(this.m_table, panel, VWResource.s_recipientsTable, VWResource.s_recipientsTable);
            this.m_table.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (VWAdminAssignReassignDialog.this.m_table == null || VWAdminAssignReassignDialog.this.m_table.getModel() == null || VWAdminAssignReassignDialog.this.m_table.getRowCount() == 0) {
                        FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }
            });
            this.addListenerForRowSelectionChanged();
            this.m_scrollPane = new JScrollPane(this.m_table);
            this.m_toRecipientPanel = this.m_vwSession.getSecurityDatabaseType() == 1 ? new VWRecipientFilterPanel(this, this.m_vwSession) : new VWRecipientComboPanel(this, this.m_vwSession);
            this.m_toRecipientPanel.reset();
            this.m_toRecipientPanel.addActionListener(this);
            panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 5, 2);
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 23;
            c.fill = 0;
            c.weighty = 0.0;
            JLabel m_participantsLabel = new JLabel(VWResource.s_fromColon);
            VWAccessibilityHelper.setAccessibility(m_participantsLabel, this, VWResource.s_from, VWResource.s_from);
            VWAccessibilityHelper.setLabelFor(m_participantsLabel, this.m_table);
            panel.add((Component)m_participantsLabel, c);
            c.gridx = 1;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)this.m_scrollPane, c);
            c.gridx = 0;
            ++c.gridy;
            c.anchor = 23;
            c.fill = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            JLabel toLabel = new JLabel(VWResource.s_toColon);
            VWAccessibilityHelper.setAccessibility(toLabel, this, VWResource.s_to, VWResource.s_to);
            panel.add((Component)toLabel, c);
            c.gridx = 1;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)((JPanel)((Object)this.m_toRecipientPanel)), c);
            if (this.m_toRecipientPanel != null && this.m_toRecipientPanel instanceof VWRecipientFilterPanel) {
                JList selectedJList = ((VWRecipientFilterPanel)this.m_toRecipientPanel).getRecipientFilterJList();
                VWAccessibilityHelper.setLabelFor(toLabel, selectedJList);
            } else if (this.m_toRecipientPanel != null && this.m_toRecipientPanel instanceof VWRecipientComboPanel) {
                JComboBox selectedJComboBox = ((VWRecipientComboPanel)this.m_toRecipientPanel).getRecipientFilterJComboBox();
                VWAccessibilityHelper.setLabelFor(toLabel, selectedJComboBox);
            }
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void setupCommentsPanel(JPanel panel) {
        JLabel commentsLabel = new JLabel(VWResource.s_currentComments);
        VWAccessibilityHelper.setAccessibility(commentsLabel, this, VWResource.s_currentComments, VWResource.s_currentComments);
        JLabel newCommentsLabel = new JLabel(VWResource.s_enterComments);
        VWAccessibilityHelper.setAccessibility(newCommentsLabel, this, VWResource.s_enterComments, VWResource.s_enterComments);
        this.m_commentsUI = new JTextArea();
        this.m_commentsUI.setText("");
        this.m_commentsUI.setLineWrap(true);
        this.m_commentsUI.setWrapStyleWord(false);
        this.m_commentsUI.setRows(4);
        this.m_commentsUI.setEditable(false);
        VWAccessibilityHelper.setAccessibility(this.m_commentsUI, this, VWResource.s_currentComments, VWResource.s_currentComments);
        VWAccessibilityHelper.setLabelFor(commentsLabel, this.m_commentsUI);
        this.m_newCommentsUI = new JTextArea();
        this.m_newCommentsUI.setText("");
        this.m_newCommentsUI.setLineWrap(true);
        this.m_newCommentsUI.setWrapStyleWord(false);
        this.m_newCommentsUI.setRows(4);
        VWAccessibilityHelper.setAccessibility(this.m_newCommentsUI, this, VWResource.s_enterComments, VWResource.s_enterComments);
        VWAccessibilityHelper.setLabelFor(newCommentsLabel, this.m_newCommentsUI);
        ButtonGroup grp = new ButtonGroup();
        this.m_appendRadio = new JRadioButton(VWResource.s_append, true);
        this.m_appendRadio.addActionListener(this);
        this.m_appendRadio.addKeyListener(VWKeyAdapter.s_keyAdapter);
        VWAccessibilityHelper.setMemberOf(this.m_appendRadio, grp);
        VWAccessibilityHelper.setAccessibility(this.m_appendRadio, panel, VWResource.s_append, VWResource.s_append);
        this.m_replaceRadio = new JRadioButton(VWResource.s_replace);
        this.m_replaceRadio.addActionListener(this);
        this.m_replaceRadio.addKeyListener(VWKeyAdapter.s_keyAdapter);
        VWAccessibilityHelper.setMemberOf(this.m_replaceRadio, grp);
        VWAccessibilityHelper.setAccessibility(this.m_replaceRadio, panel, VWResource.s_replace, VWResource.s_replace);
        grp.add(this.m_appendRadio);
        grp.add(this.m_replaceRadio);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        panel.setBorder(new VWTitledBorder(VWResource.s_comments));
        VWAccessibilityHelper.setAccessibility(panel, this, VWResource.s_comments, VWResource.s_comments);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.insets = new Insets(5, 2, 0, 5);
        panel.add((Component)this.m_appendRadio, c);
        c.gridx = 1;
        c.gridwidth = 0;
        panel.add((Component)this.m_replaceRadio, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.fill = 0;
        panel.add((Component)commentsLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this.m_commentsUI), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        panel.add((Component)newCommentsLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this.m_newCommentsUI), c);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        GridBagConstraints gbCons = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 2, 6, 6);
            this.m_okButton = new JButton(VWResource.s_OK);
            this.m_okButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_OK, VWResource.s_OK);
            this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_applyButton = new JButton(VWResource.s_apply);
            this.m_applyButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_applyButton, this, VWResource.s_apply, VWResource.s_apply);
            this.m_applyButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_applyButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void disableControls() {
        this.m_toRecipientPanel.setEnabled(false);
        this.m_delegateUI.setEnabled(false);
        this.m_applyButton.setEnabled(false);
        this.m_okButton.setEnabled(false);
        this.m_newCommentsUI.setEnabled(false);
        this.m_newCommentsUI.setText("");
    }

    private void resetControls() {
        this.m_table.clearSelection();
        this.m_toRecipientPanel.reset();
        this.setDelegateState();
        this.refreshCurrentCommentsPanel();
        this.setButtonState();
    }

    private void updateControls() {
        this.m_toRecipientPanel.setEnabled(true);
        this.setDelegateState();
        this.refreshCurrentCommentsPanel();
        this.setButtonState();
    }

    private void setButtonState() {
        boolean bEnable = false;
        if (this.m_table.getSelectedRowCount() > 0 && this.m_toRecipientPanel.hasValidSelection()) {
            bEnable = true;
        }
        this.m_applyButton.setEnabled(bEnable);
        this.m_okButton.setEnabled(bEnable);
    }

    private void setDelegateState() {
        int[] selectedRows = this.m_table.getSelectedRows();
        if (selectedRows.length <= 0) {
            this.m_delegateUI.setEnabled(false);
        } else if (this.isAnyWorkCanBeDelegated()) {
            this.m_delegateUI.setEnabled(true);
        } else {
            this.m_delegateUI.setEnabled(false);
        }
    }

    private void refreshCurrentCommentsPanel() {
        try {
            int[] selectedRows = this.m_table.getSelectedRows();
            this.m_newCommentsUI.setEnabled(false);
            if (selectedRows.length <= 0) {
                this.m_commentsUI.setText("");
            } else {
                this.m_newCommentsUI.setEnabled(true);
                if (this.isUniqueComments()) {
                    DataObject data = (DataObject)this.m_tableModel.getObjectAt(selectedRows[0]);
                    this.m_commentsUI.setText(data.getCurrentComments());
                } else {
                    this.m_commentsUI.setText(VWResource.s_variousValues);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addListenerForRowSelectionChanged() {
        ListSelectionModel rowSM = this.m_table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    VWAdminAssignReassignDialog.this.disableControls();
                } else if (!e.getValueIsAdjusting()) {
                    VWAdminAssignReassignDialog.this.updateControls();
                }
            }
        });
    }

    private boolean isAnyWorkCanBeDelegated() {
        try {
            int[] selectedRows = this.m_table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                DataObject data = (DataObject)this.m_tableModel.getObjectAt(selectedRows[i]);
                VWWorkObject wob = data.getWob();
                if (!this.isWorkCanBeDelegated(wob)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    private boolean isWorkCanBeDelegated(VWWorkObject wob) {
        try {
            VWQueue queue = this.m_resultsPane.getSession().getQueue(wob.getCurrentQueueName());
            if (queue.getQueueType() == 2 && !wob.getIsTracker()) {
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
        }
        return false;
    }

    private boolean isUniqueComments() {
        try {
            int[] selectedRows = this.m_table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                DataObject data = (DataObject)this.m_tableModel.getObjectAt(selectedRows[i]);
                String comments = data.getCurrentComments();
                for (int j = 0; j < selectedRows.length; ++j) {
                    DataObject anotherData;
                    String anotherComment;
                    if (i == j || VWStringUtils.compare(comments, anotherComment = (anotherData = (DataObject)this.m_tableModel.getObjectAt(selectedRows[j])).getCurrentComments()) == 0) continue;
                    return false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    private void reassignWork() {
        try {
            int[] selectedRows = this.m_table.getSelectedRows();
            VWParticipant newAssignee = this.m_toRecipientPanel.getSelectedValue();
            String newComments = this.m_newCommentsUI.getText();
            if (newAssignee == null) {
                return;
            }
            for (int i = 0; i < selectedRows.length; ++i) {
                DataObject data = (DataObject)this.m_tableModel.getObjectAt(selectedRows[i]);
                VWWorkObject wob = data.getWob();
                VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, this.m_wobsList);
                String comments = data.getCurrentComments();
                if (this.m_appendRadio.isSelected()) {
                    if (comments == null) {
                        comments = "";
                    }
                    if (newComments != null && newComments.length() > 0) {
                        if (comments.length() > 0) {
                            comments = comments + "\n";
                        }
                        comments = comments + newComments;
                    }
                } else {
                    comments = newComments != null ? newComments : null;
                }
                wob.setFieldValue("F_Comment", comments, true);
                String queueName = "Inbox";
                if (wob.getIsTracker()) {
                    queueName = "Tracker";
                }
                if (this.isWorkCanBeDelegated(wob)) {
                    wob.doReassignByDomain(newAssignee.getDomainName(), newAssignee.getParticipantName(), this.m_delegateUI.isSelected(), queueName);
                } else {
                    wob.doReassignByDomain(newAssignee.getDomainName(), newAssignee.getParticipantName(), false, queueName);
                }
                woData.setToBeRemoved(true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
        }
    }

    private void refreshPanel() {
        try {
            this.m_tableModel.refreshTable();
            this.m_table.tableChanged(null);
            this.m_table.setSize(this.m_scrollPane.getSize());
            this.m_table.sizeColumnsToFit(-1);
            this.resetControls();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeReferences() {
        if (this.m_toRecipientPanel != null) {
            this.m_toRecipientPanel.removeActionListener(this);
            this.m_toRecipientPanel.removeReferences();
            this.m_toRecipientPanel = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.removeReferences();
            this.m_tableModel = null;
        }
        super.removeReferences();
    }

    class MyTableModel
    extends AbstractTableModel {
        private Vector m_columnNames = new Vector();
        private Vector m_rowCache = new Vector();
        private Vector m_wobsList;

        public MyTableModel(Vector wobsList) {
            this.m_wobsList = wobsList;
            this.initColumns();
            this.initRowData();
        }

        public int getColumnCount() {
            return this.m_columnNames.size();
        }

        public int getRowCount() {
            return this.m_rowCache.size();
        }

        public String getColumnName(int col) {
            if (col < this.getColumnCount()) {
                return (String)this.m_columnNames.elementAt(col);
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            DataObject data = (DataObject)this.m_rowCache.elementAt(row);
            Vector rowData = data.getRowData();
            if (rowData != null) {
                return rowData.elementAt(col);
            }
            return null;
        }

        public Object getObjectAt(int row) {
            return (DataObject)this.m_rowCache.elementAt(row);
        }

        private void initColumns() {
            this.m_columnNames.addElement(VWResource.s_participantName);
            this.m_columnNames.addElement(VWResource.s_queue);
            this.m_columnNames.addElement(VWResource.s_stepLabel);
            this.m_columnNames.addElement(VWResource.s_subject);
        }

        private void initRowData() {
            try {
                this.m_rowCache.removeAllElements();
                for (int i = 0; i < this.m_wobsList.size(); ++i) {
                    VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
                    if (woData.isToBeRemoved()) continue;
                    VWWorkObject wob = woData.getWob();
                    this.m_rowCache.addElement(new DataObject(wob));
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }

        private void refreshTable() {
            this.initRowData();
        }

        private void removeReferences() {
            if (this.m_rowCache != null) {
                this.m_rowCache.removeAllElements();
            }
            if (this.m_wobsList != null) {
                this.m_wobsList.removeAllElements();
                this.m_wobsList = null;
            }
            if (this.m_columnNames != null) {
                this.m_columnNames.removeAllElements();
                this.m_columnNames = null;
            }
        }
    }

    class DataObject {
        private Vector m_rowData = new Vector();
        private String m_currentComments = null;
        private VWWorkObject m_wob = null;

        public DataObject(VWWorkObject wob) {
            try {
                this.m_wob = wob;
                this.refreshData();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }

        private void refreshData() {
            try {
                this.m_wob.doRefresh(true, true);
                this.m_rowData.removeAllElements();
                VWParticipantItem pItem = new VWParticipantItem(this.m_wob.getParticipantNamePx());
                this.m_rowData.addElement(pItem.getDisplayName());
                this.m_rowData.addElement(this.m_wob.getCurrentQueueName());
                this.m_rowData.addElement(this.m_wob.getStepName());
                this.m_rowData.addElement(this.m_wob.getSubject());
                this.m_currentComments = this.m_wob.getComment();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
            }
        }

        private Vector getRowData() {
            return this.m_rowData;
        }

        private VWWorkObject getWob() {
            return this.m_wob;
        }

        private String getCurrentComments() {
            return this.m_currentComments;
        }
    }
}

